#include "pch.h"
#include "Common.hpp"
#include "MsgAttrs.h"

// we will use alphabetically sorted array of message attribute strings
// to find index in array of pair attribute-flag

// helpfull string array of message attributes and flags (both in one array

static LPCTSTR	arrszMessageAttrs[] = {
	TEXT("AuditReq"),		// ATTR_AUDIT_REQ
	TEXT("ConfirmReq"),		// FLAG_CONFIRM_REQ
	TEXT("Crash"),			// ATTR_CRASH
	TEXT("Direct"),			// FLAG_DIRECT
	TEXT("FileAttached"),		// ATTR_FILE_ATTACHED
	TEXT("FileReq"),		// ATTR_FILE_REQ
	TEXT("FileUpdateReq"),		// ATTR_FILE_UPDATE_REQ
	TEXT("HoldForPickup"),		// ATTR_HOLD_FOR_PICKUP
	TEXT("Immediate"),		// FLAG_IMMEDIATE
	TEXT("IsReturnReceipt"),	// ATTR_IS_RETURN_RECEIPT
	TEXT("KillFileSent"),		// FLAG_KILL_FILE_SENT
	TEXT("KillSent"),		// ATTR_KILL_SENT
	TEXT("Local"),			// ATTR_LOCAL
	TEXT("Lock"),			// FLAG_LOCK
	TEXT("Orphan"),			// ATTR_ORPHAN
	TEXT("Private"),		// ATTR_PRIVATE
	TEXT("Received"),		// ATTR_RECEIVED
	TEXT("ReturnReceiptReq"),	// ATTR_RETURN_RECEIPT_REQ
	TEXT("Sent"),			// ATTR_SENT
	TEXT("Transit"),		// ATTR_TRANSIT
	TEXT("TruncateFile")		// FLAG_TRUNCATE_FILE
};

// corresponding array of pairs (..., attr, flag, ...) for attribute strings
static uint16	arrui16Attrs[] = {
	// attr				flag
	ATTR_AUDIT_REQ,			0,
	0,				FLAG_CONFIRM_REQ,
	ATTR_CRASH,			0,
	0,				FLAG_DIRECT,
	ATTR_FILE_ATTACHED,		0,
	ATTR_FILE_REQ,			0,
	ATTR_FILE_UPDATE_REQ,		0,
	ATTR_HOLD_FOR_PICKUP,		0,
	0,				FLAG_IMMEDIATE,
	ATTR_IS_RETURN_RECEIPT,		0,
	0,				FLAG_KILL_FILE_SENT,
	ATTR_KILL_SENT,			0,
	ATTR_LOCAL,			0,
	0,				FLAG_LOCK,
	ATTR_ORPHAN,			0,
	ATTR_PRIVATE,			0,
	ATTR_RECEIVED,			0,
	ATTR_RETURN_RECEIPT_REQ,	0,
	ATTR_SENT,			0,
	ATTR_TRANSIT,			0,
	0,				FLAG_TRUNCATE_FILE
};

static int KeyCompare(const void* p1, const void* p2) {
	LPCTSTR		szKey    = (LPCTSTR)p1;
	LPCTSTR*	pszValue = (LPCTSTR*)p2;
	return (lstrcmpi( szKey, *pszValue ));
}


bool GetAttrOrFlag(LPCTSTR szAttrValue, uint16& nAttr, uint16& nFlag) {
	LPCTSTR*	pszResult;

	pszResult = (LPCTSTR*)::bsearch( szAttrValue, arrszMessageAttrs,
					 sizeof(arrszMessageAttrs)/sizeof(LPCTSTR),
					 sizeof(LPCTSTR), KeyCompare );

	if (pszResult == NULL) {
		// string not found
		return (false);
	}

	// get string index
	ptrdiff_t	nIndex = pszResult - arrszMessageAttrs;

	// set attribute and flag
	nAttr = arrui16Attrs[nIndex << 1];
	nFlag = arrui16Attrs[(nIndex << 1) + 1];

	return(true);
}


tstring	MsgAttrsToString(uint16 nAttrs, uint16 nFlags) {
	tstring	sResult = TEXT("");

	int	nSubstringsCount = 0;

	for (int i = 0, j = 0; i < sizeof(arrszMessageAttrs)/sizeof(LPCTSTR); i++, j += 2) {
		// we have j-th values for i-th string
		// check if they are provided
		// 1) attribute
		if (nAttrs & arrui16Attrs[j]) {
			// add delimiter if have to
			if (nSubstringsCount > 0) {
				sResult += TEXT(" ");
			}
			// keep value
			sResult += arrszMessageAttrs[i];
			// increase counter
			nSubstringsCount++;
		}
		// 2) flag
		if (nFlags & arrui16Attrs[j+1]) {
			// add delimiter if have to
			if (nSubstringsCount > 0) {
				sResult += TEXT(" ");
			}
			// keep value
			sResult += arrszMessageAttrs[i];
			// increase counter
			nSubstringsCount++;
		}
	}

	return (sResult);
}
